//arg0 - noise surface, arg1 - outer intensity, arg2 - inner radius [0,1], arg3 - outer radius [0,1]


var r_s,cur_r,off,W1,H1,D,P,p,M,Q;
r_s=surface_create(map_dimx,map_dimy);
surface_set_target(r_s)
draw_clear(make_color_hsv(0,0,argument1));     //ring intensity - the higher, the stronger
W1=(argument3-argument2)*0.5*map_dimx;     //szerokosc prostokatnej obreczy w X
H1=(argument3-argument2)*0.5*map_dimy;     //szerokosc prostokatnej obreczy w Y
P=max(W1,H1);               //wieksza z szerokosci
p=min(W1,H1);               //mniejsza z szerokosci
M=max(map_dimx,map_dimy);   //wiekszy z wymiarow mapy
D=argument1/P;              //pozwala znalezc konieczny kolor i alphe
Q=p/P;                      //stosunek wymiarow szerokosci obreczy (zawsze <= od 1)
draw_set_color(make_color_hsv(0,0,D));
draw_set_alpha(1/P);
draw_set_blend_mode(bm_subtract);
off=max(1,(1-argument3)*M/2);
for(cur_r=M*argument3-2;cur_r>=M*argument2;cur_r-=2)
{
    if(map_dimx > map_dimy)
        draw_rectangle(off,off*Q,off+cur_r-1,(off+cur_r-1)*Q,0);
    else
        draw_rectangle(off*Q,off,(off+cur_r-1)*Q,off+cur_r-1,0);
    off++;
}
surface_reset_target();
draw_set_alpha(1);
surface_set_target(argument0)
draw_set_blend_mode(bm_add);
draw_surface(r_s,0,0);
draw_set_blend_mode(bm_normal);
surface_reset_target();
surface_free(r_s);
